sampler tRenderTexture 	: register(s0);
sampler tNormalMap		: register(s1);
float fDistAmt			: register(c0); // = 0.0005;
float fPsImgScale		: register(c1);
float fPSTimer			: register(c2);
float fVSTimer;
float fAlphaMult		: register(c3);

float fScale : register(c12);
float fScroll: register(c13);
float fVsImgScale : register(c15);

struct PS_INPUT
{
   float2 vTexCoord0 : TEXCOORD0;
   float2 vTexCoord1 : TEXCOORD1;
   float2 vTexCoord2 : TEXCOORD2;
};

struct VS_OUTPUT 
{
   float4 vPos:     POSITION;
   float2 vTexCoord0 : TEXCOORD0;
   float2 vTexCoord1 : TEXCOORD1;
   float2 vTexCoord2 : TEXCOORD2;
};

float4 ps_main( PS_INPUT i, uniform bool doMumu ) : COLOR0
{
	float fSizeScale = 1.0;
	float fRadius = 1.0;
	float fBumpStrength = 1.7;

	// fetch from normal map with scrolling coords: this returns a RG value (b is 0).
	float3 vNormal0 = tex2D (tNormalMap, i.vTexCoord1);
	float3 vNormal1 = tex2D (tNormalMap, i.vTexCoord2);

	//return float4(vNormal0.x, vNormal0.y, vNormal1.x, 1); 

	// scale and bias: range becomes [-1, 1]
	vNormal0.rgb = (vNormal0.rgb * (doMumu ? 1.0 : 2.0)) - 1.0;
	vNormal1.rgb = (vNormal1.rgb * (doMumu ? 5.0 : 2.0)) - 1.0;

	// sum and scale: adding our normal map values together and multiplying by the bump strength
	// will give us how far away to sample.
	float2 offset = (vNormal0.xy + vNormal1.xy) * fBumpStrength;

	//return float4(offset.xy, 0, 1); 
	// compute distorted texture coords: we'll offset the default texture coord by the above.
	offset.xy = (offset.xy * fDistAmt*fPsImgScale * (doMumu ? 0.25 : 1.0)) + i.vTexCoord0;

	// just returns the regular texture
	//return tex2D(tRenderTexture, i.vTexCoord0); 

	// fetch the distorted color
	float4 c = tex2D(tRenderTexture, offset);	
	c.a *= fAlphaMult;
	return c;
	
	//some weird alpha effect
	/*float4 c = tex2D(tRenderTexture, offset);
	c.a = fmod(c.b/c.r/c.g + i.vTexCoord2.x + i.vTexCoord2.x*i.vTexCoord1.x/100, fmod(fPSTimer, 10));
	return c;*/
	
	// This makes a totally weird messed up image that's theoretically cool
	/*float4 c = tex2D(tRenderTexture, offset);
	float val = fmod(i.vTexCoord0.x * i.vTexCoord0.y/30 * fPSTimer + i.vTexCoord1.x*i.vTexCoord1.x/40, 1.0);
	c.r += val*1;
	c.r = fmod(c.r, 1.0);
	c.g = fmod(c.r * fPSTimer, 0.40);
	
	return c;*/
	
}

VS_OUTPUT vs_main(float4 Pos: POSITION, float4 vTexCoord0 : TEXCOORD0, uniform bool doMumu)
{
	VS_OUTPUT Out;
	   
	float4 vBumpScroll0 = float4(-fScroll, 0.005, 0, 0);   
	float4 vBumpScroll1 = float4(fScroll, 0.0075, 0, 0);
	     
	float4 vBumpScale0 = float4(fScale, fScale * (doMumu ? 10.0 : 1.0), 0, 0);
	float4 vBumpScale1 = float4(fScale, fScale, 0, 0);

	Out.vPos = float4(Pos.xy, 0, 1);
	//if (Out.vPos.x > 0)
	//	Out.vPos.x -= 0.7f;
	//Out.vTexCoord0 = Pos.xy * 0.5 + 0.5;			// Pos is from -1 to 1: map to [0, 1]
	//Out.vTexCoord0.y = 1.0 - Out.vTexCoord0.y;	// invert Y to make image draw properly
	Out.vTexCoord0 = vTexCoord0;
	   
	// bump texture coords: the first part scales tex coord 0, the second animates it by 
	// multiplying a tenth of the timer by the scroll parameter.
	Out.vTexCoord1 = (Out.vTexCoord0 * vBumpScale0.xy * fVsImgScale) + (fVSTimer * (doMumu ? 0.5 : 1.0) / 10 * vBumpScroll0);
	Out.vTexCoord2 = (Out.vTexCoord0 * vBumpScale1.xy * fVsImgScale) + (fVSTimer * (doMumu ? 0.5 : 1.0) / 10 * vBumpScroll1);
	  
	return Out;
}

technique Default
{
	pass P0
	{
		PixelShader = compile ps_2_0 ps_main(false);
		VertexShader = compile vs_2_0 vs_main(false);
	}
}

technique Mumu
{
	pass P0
	{
		PixelShader = compile ps_2_0 ps_main(true);
		VertexShader = compile vs_2_0 vs_main(true);
	}
}